/*	Ian Bailey
	ECE 4220 project
	imby96@mail.missouri.edu
	05/14/2015
 */


#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>

#define SERVERPORT  "5000"                  //Hardcoded the port number

#define MAXBUFLEN   40                      //Hardcoded the length for the buffers
#define PIIPADDR    "192.168.1.100"         //Hardcoded the static IP address of the server (pi running my level controller)


int main(void)
{
    int sockfd, i, rv, numbytes;
    struct addrinfo hints, *servinfo, *p;
    struct sockaddr_storage their_addr;
    socklen_t addr_len;
    
    char buf[MAXBUFLEN];
    char upperBuf[MAXBUFLEN];
    
    char recievedMessage[MAXBUFLEN];

    memset(&hints, 0, sizeof hints);
    hints.ai_family = AF_UNSPEC;
    hints.ai_socktype = SOCK_DGRAM;
    
    int j = 0;
    int flag = 0;
    
    //gets info for client computer
    if ((rv = getaddrinfo(PIIPADDR, SERVERPORT, &hints, &servinfo)) != 0) {
        fprintf(stderr, "getaddrinfo: %s\n", gai_strerror(rv));
        return 1;
    }
    
    //loop through all the results and make a socket
    for(p = servinfo; p != NULL; p = p->ai_next) {
        if ((sockfd = socket(p->ai_family, p->ai_socktype, p->ai_protocol)) < 0) {
            perror("client: socket");
            continue;
        }
        
        break;
    }
    
    //checks for successful bind
    if (p == NULL) {
        fprintf(stderr, "client: failed to bind socket\n");
        return 2;
    }
    
    addr_len = sizeof their_addr;
    
    //sends message that the connection was established
    if ((numbytes = sendto(sockfd, "REMOTE CONNECTION HAS BEEN ESABLISHED", MAXBUFLEN, 0, p->ai_addr, p->ai_addrlen)) < 0) {
        perror("client: sendto connection");
        exit(1);
    }
    
    //gets message to send and adds NULL terminator
    scanf("%s", buf);
    strcat(buf, "\0");
    
    //loops until user enters '!'
    while(buf[0] != '!'){
        
        //converts the message to all upper case
        for (i = 0; i < strlen(buf); i++){
            upperBuf[i] = toupper(buf[i]);
        }
        
        //sends upper case message
        if ((numbytes = sendto(sockfd, upperBuf, strlen(upperBuf), 0, p->ai_addr, p->ai_addrlen)) < 0) {
            perror("client: sendto");
            exit(1);
        }
        
        //if you requested the level
        if (strcmp(upperBuf, "LEVEL\0") == 0){
            
            //gets the message from the server of the current level
            if ((numbytes = recvfrom(sockfd, recievedMessage, MAXBUFLEN-1, 0, p->ai_addr , &p->ai_addrlen)) < 0){
                perror("recieving messagge");
                exit(1);
            }
            
            //checks for a low level
            if (strcmp(recievedMessage, "0") == 0){
                printf("Water Level: Low (pump on)\n");
            }
            
            //checks for an acceptable level
            else if (strcmp(recievedMessage, "1") == 0){
                printf("Water Level: Acceptable Range\n");
            }
            
            //checks for a high level
            else if (strcmp(recievedMessage, "2") == 0){
                printf("Water Level: High (drain on)\n");
            }
        }
        
        //if you requested to go into, or exit manual mode
        if (strcmp(upperBuf, "MANUAL\0") == 0){
            
            //gets the conformation and prints it (on or off)
            if ((numbytes = recvfrom(sockfd, recievedMessage, MAXBUFLEN-1, 0, p->ai_addr , &p->ai_addrlen)) < 0){
                perror("recieving messagge");
                exit(1);
            }
            
            printf("%s\n", recievedMessage);
            
            //changes the flag to keep track it manual is on or off
            if (flag == 0)
                flag = 1;
            
            else
                flag = 0;
        }
        
        //if in manual, and you request to controll the drain or the pump
        if ((strcmp(upperBuf, "PUMP\0") == 0 && flag == 1) || (strcmp(upperBuf, "DRAIN\0") == 0 && flag == 1)){
            
            if ((numbytes = recvfrom(sockfd, recievedMessage, MAXBUFLEN-1, 0, p->ai_addr , &p->ai_addrlen)) < 0){
                perror("recieving messagge");
                exit(1);
            }
            
            //checks to see if you and the server are on the same level
            if (strcmp(recievedMessage, "ENTER [ON/OFF]") == 0){
                printf("%s\n", recievedMessage);        //prints on/off
                bzero(recievedMessage, MAXBUFLEN);      //resets the buffers
                bzero(buf, MAXBUFLEN);
                bzero(upperBuf, MAXBUFLEN);
                
                //loop until a valid command
                do {
                    //scans and loads the users input
                    scanf("%s", buf);
                    strcat(buf, "\0");
                    
                    //converts the message to all upper case
                    for (i = 0; i < strlen(buf); i++){
                        upperBuf[i] = toupper(buf[i]);
                    }
                    
                    //checks if the command was valid
                    if(strcmp(upperBuf, "ON\0") == 0 || strcmp(upperBuf, "OFF\0") == 0){
                        //sends upper case message
                        if ((numbytes = sendto(sockfd, upperBuf, strlen(upperBuf), 0, p->ai_addr, p->ai_addrlen)) < 0) {
                            perror("client: sendto");
                            exit(1);
                        }
                        
                        j = 1;
                    }
                    
                } while (j != 1);
                
                if ((numbytes = recvfrom(sockfd, recievedMessage, MAXBUFLEN-1, 0, p->ai_addr , &p->ai_addrlen)) < 0){
                    perror("recieving messagge");
                    exit(1);
                }
                
                printf("%s\n", recievedMessage);
            }
        }
        
        
        
        //cleans up the buffers
        bzero(buf, MAXBUFLEN);
        bzero(upperBuf, MAXBUFLEN);
        bzero(recievedMessage, MAXBUFLEN);
        
        //reprompts for next message
        scanf("%s", buf);
        strcat(buf, "\0");
    }
    
    //sends connection closed message
    if ((numbytes = sendto(sockfd, "REMOTE CONNECTION HAS BEEN CLOSED", MAXBUFLEN, 0, p->ai_addr, p->ai_addrlen)) < 0) {
        perror("client: sendto closed");
        exit(1);
    }
    
    //closes everything up
    freeaddrinfo(servinfo);
    close(sockfd);
    
    return 0;
}